#define WANT_MATH
#define WANT_STREAM

#include "include.h"
#include "myexcept.h"
#include "array1.h"
#include "cx.h"
#include "cxtest.h"

#ifdef use_namespace
using namespace RBD_COMMON;             // needed for VC++
using namespace RBD_COMPLEX;
#endif




static Real real(Real x) { return x; }
static Real imag(Real) { return 0.0; }

static Real OverallMax = 0.0;

template <class T1, class T2>
void PrintMaxDiff(const array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   Real maxdiff = 0.0;
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++)
   {
      Real diff = fabs(A(i,j) - B(i,j));
      if (maxdiff < diff) maxdiff = diff;
      if (diff > 0.0000001)
      {
         cout << i << " " << j << ": ";
         cout << real(A(i,j)) << " " << imag(A(i,j)) << "; ";
         cout << real(B(i,j)) << " " << imag(B(i,j)) << " -> " << diff << endl;
      }
   }
   cout << maxdiff << endl;
   if (OverallMax < maxdiff) OverallMax = maxdiff;
}

template <class T1, class T2>
void PrintMaxRelDiff(const array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   Real maxdiff = 0.0;
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++)
   {
      Real diff = fabs(A(i,j) - B(i,j));
      Real sum = fabs(A(i,j)) + fabs(B(i,j));
      if (sum != 0.0) diff /= sum;
      if (maxdiff < diff) maxdiff = diff;
      if (diff > 0.0000001)
      {
         cout << i << " " << j << ": ";
         cout << real(A(i,j)) << " " << imag(A(i,j)) << "; ";
         cout << real(B(i,j)) << " " << imag(B(i,j)) << " -> " << diff << endl;
      }
   }
   cout << maxdiff << endl;
   if (OverallMax < maxdiff) OverallMax = maxdiff;
}

template <class T1, class T2>
void operator+=(array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) += B(i,j);
}

template <class T1, class T2>
void operator-=(array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) -= B(i,j);
}

template <class T1, class T2>
void operator*=(array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) *= B(i,j);
}

template <class T1, class T2>
void operator/=(array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) /= B(i,j);
}

template <class T1>
void operator+=(array2<T1>& A, ImaginaryUnit)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) += _I_;
}

template <class T1>
void operator-=(array2<T1>& A, ImaginaryUnit)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) -= _I_;
}

template <class T1>
void operator*=(array2<T1>& A, ImaginaryUnit)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) *= _I_;
}

template <class T1>
void operator/=(array2<T1>& A, ImaginaryUnit)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++) A(i,j) /= _I_;
}

void AssertIsValid(const array2<Polar>& p)
{
   int nr = p.N_rows(); int nc = p.N_cols();
   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++)
      p(i,j).AssertIsValid();
}


template <class T1, class T2>
void TestCompare(const array2<T1>& A, const array2<T2>& B)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   bool OnDiag = true; bool OffDiag = false;
   int eq = 0; int neq = 0;

   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++)
   {
      CX a(A(i,j)), b(B(i,j));
      if (a == b)                 // complex versions equal
      {
         if ( A(i,j) == B(i,j) ) {} else OnDiag = false;
         if ( A(i,j) != B(i,j) ) OnDiag = false;
         eq++;
      }
      else
      {
         if ( A(i,j) != B(i,j) ) {} else OffDiag = true;
         if ( A(i,j) == B(i,j) ) OffDiag = true;
         neq++;
      }
   }

   if (OnDiag && !OffDiag) cout << "test passes" << endl;
   else { cout << "test fails" << endl; OverallMax = 100; }
   cout << "eq = " << eq << ";  neq = " << neq << endl;
}

template <class T1>
void TestCompareWithI(const array2<T1>& A)
{
   int nr = A.N_rows(); int nc = A.N_cols();
   bool OnDiag = true; bool OffDiag = false;
   int eq = 0; int neq = 0;

   for (int i = 0; i < nr; i++) for (int j = 0; j < nc; j++)
   {
      CX a(A(i,j));
      if (a == CX(0,1))                 // complex versions equal
      {
         if ( A(i,j) == _I_ && _I_ == A(i,j) ) {} else OnDiag = false;
         if ( A(i,j) != _I_ || _I_ != A(i,j) ) OnDiag = false;
         eq++;
      }
      else
      {
         if ( A(i,j) != _I_ && _I_ != A(i,j) ) {} else OffDiag = true;
         if ( A(i,j) == _I_ || _I_ == A(i,j) ) OffDiag = true;
         neq++;
      }
   }

   if (OnDiag && !OffDiag) cout << "test passes" << endl;
   else { cout << "test fails" << endl; OverallMax = 100; }
   cout << "eq = " << eq << ";  neq = " << neq << endl;
}
Real cxtest2()
{
   cout << "begin binary tests" << endl;

   int n = 121;
   int i, j;
   array2<CX>    CA(n,n), CB(n,n), CC(n,n), CD(n,n);
   array2<CX>    CE(n,n), CF(n,n), CG(n,n), CH(n,n);
   array2<Polar> PA(n,n), PB(n,n), PC(n,n), PD(n,n);
   array2<Real>  RA(n,n), RB(n,n), RC(n,n), RD(n,n);
   array2<Real>  RE(n,n), RF(n,n), RG(n,n), RH(n,n);
   array2<Imag>  IA(n,n), IB(n,n), IC(n,n), ID(n,n);
   array2<Imag>  IE(n,n), IF(n,n), IG(n,n), IH(n,n);

   // load CA and CB so we get a lot of combinations of values
   // including pure real and pure imaginary and equal real and imaginary parts

   for (i = 0; i < n; i++)
   {
      int j, k;
      CA(0, i) = 0.0;
      CA(1, i) = 1.0;
      CA(2, i) = -1.0;
      CA(3, i) = 1.9;
      CA(4, i) = -1.9;
      CA(5, i) = 0.75;
      CA(6, i) = -0.75;
      CA(7, i) = 2.35;
      CA(8, i) = -2.35;
      CA(9, i) = 4.33;
      CA(10, i) = -4.33;
      for (j = 1; j <= 10; j++) CA(j + 10, i) = Imag(CA(j, i).real());
      for (j = 1; j <= 10; j++) for (k = 1; k <= 10; k++)
         CA(j + 10 * k + 10, i) = CA(j, i) + CA(k + 10, i);
   }

   for (i = 0; i < n; i++)
   { for (int j = 0; j < n; j++) { CB(i, j) = CA(j, i); }  }

   // get Real part and Imaginary part and make Polar version

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      RA(i,j) = real(CA(i,j)); IA(i,j) = Imag(imag(CA(i,j))); PA(i,j) = CA(i,j);
      RB(i,j) = real(CB(i,j)); IB(i,j) = Imag(imag(CB(i,j))); PB(i,j) = CB(i,j);
      RC(i,j) = imag(CA(i,j)); RD(i,j) = imag(CB(i,j));
      PA(i,j).AssertIsValid(); PB(i,j).AssertIsValid();
   }

   PrintMaxDiff(PA, CA);  PrintMaxDiff(PB, CB);

   cout << "check complex op complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + CB(i,j);
      CD(i,j) = CX(RA(i,j)+RB(i,j), RC(i,j)+RD(i,j));
   }
   PrintMaxDiff(CC,CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - CB(i,j);
      CD(i,j) = CX(RA(i,j)-RB(i,j), RC(i,j)-RD(i,j));
   }
   PrintMaxDiff(CC,CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) * CB(i,j);
      CD(i,j) = CX(RA(i,j)*RB(i,j)-RC(i,j)*RD(i,j),
                   RA(i,j)*RD(i,j)+RB(i,j)*RC(i,j));
   }
   PrintMaxDiff(CC,CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (j != 0)
      {
         Real f = cabs(CB(i,j)); f = f * f;
         CC(i,j) = CA(i,j) / CB(i,j);
         CD(i,j) = CX((RA(i,j)*RB(i,j)+RC(i,j)*RD(i,j))/f,
                      (RB(i,j)*RC(i,j)-RA(i,j)*RD(i,j))/f);
      }
      else { CC(i,j) = 0.0; CD(i,j) = 0.0; }
   }
   PrintMaxDiff(CC,CD);

   cout << "check complex op real, real op complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + RB(i,j);
      CD(i,j) = RB(i,j) + CA(i,j);
      CE(i,j) = CA(i,j) + CX(RB(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - RB(i,j);
      CD(i,j) = RB(i,j) - CA(i,j);
      CE(i,j) = CA(i,j) - CX(RB(i,j));
      CF(i,j) = CX(RB(i,j)) - CA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) * RB(i,j);
      CD(i,j) = RB(i,j) * CA(i,j);
      CE(i,j) = CA(i,j) * CX(RB(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RB(i,j) != 0.0)
      {
         CC(i,j) = CA(i,j) / RB(i,j);
         CE(i,j) = CA(i,j) / CX(RB(i,j));
      }
      else { CC(i,j) = 0; CE(i,j) = 0; }
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(RB(i,j)) / CA(i,j);
         CD(i,j) = RB(i,j) / CA(i,j);
      }
      else { CD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check complex op imag, imag op complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + IB(i,j);
      CD(i,j) = IB(i,j) + CA(i,j);
      CE(i,j) = CA(i,j) + CX(IB(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - IB(i,j);
      CD(i,j) = IB(i,j) - CA(i,j);
      CE(i,j) = CA(i,j) - CX(IB(i,j));
      CF(i,j) = CX(IB(i,j)) - CA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) * IB(i,j);
      CD(i,j) = IB(i,j) * CA(i,j);
      CE(i,j) = CA(i,j) * CX(IB(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0.0)
      {
         CC(i,j) = CA(i,j) / IB(i,j);
         CE(i,j) = CA(i,j) / CX(IB(i,j));
      }
      else { CC(i,j) = 0; CE(i,j) = 0; }
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(IB(i,j)) / CA(i,j);
         CD(i,j) = IB(i,j) / CA(i,j);
      }
      else { CD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check complex op _I_, _I_ op complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + _I_;
      CD(i,j) = _I_ + CA(i,j);
      CE(i,j) = CA(i,j) + CX(0,1);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - _I_;
      CD(i,j) = _I_ - CA(i,j);
      CE(i,j) = CA(i,j) - CX(0,1);
      CF(i,j) = CX(0,1) - CA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) * _I_;
      CD(i,j) = _I_ * CA(i,j);
      CE(i,j) = CA(i,j) * CX(0,1);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) / _I_;
      CE(i,j) = CA(i,j) / CX(0,1);
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(0,1) / CA(i,j);
         CD(i,j) = _I_ / CA(i,j);
      }
      else { CD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check real op imag, imag op real" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) + IB(i,j);
      CD(i,j) = IB(i,j) + RA(i,j);
      CE(i,j) = CX(RA(i,j)) + CX(IB(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) - IB(i,j);
      CD(i,j) = IB(i,j) - RA(i,j);
      CE(i,j) = CX(RA(i,j)) - CX(IB(i,j));
      CF(i,j) = CX(IB(i,j)) - CX(RA(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      IE(i,j) = RA(i,j) * IB(i,j);
      IF(i,j) = IB(i,j) * RA(i,j);
      CE(i,j) = CX(RA(i,j)) * CX(IB(i,j));
   }
   PrintMaxDiff(IE,CE);  PrintMaxDiff(IF,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0.0)
      {
         IE(i,j) = RA(i,j) / IB(i,j);
         CE(i,j) = CX(RA(i,j)) / CX(IB(i,j));
      }
      else { IE(i,j) = Imag(0.0); CE(i,j) = 0; }
      if (RA(i,j) != 0.0)
      {
         IF(i,j) = IB(i,j) / RA(i,j);
         CF(i,j) = CX(IB(i,j)) / CX(RA(i,j));
      }
      else { IF(i,j) = Imag(0.0); CF(i,j) = 0; }
   }
   PrintMaxDiff(IE,CE);  PrintMaxDiff(IF,CF);

   cout << "check imag op imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      IE(i,j) = IA(i,j) + IB(i,j);
      CE(i,j) = CX(IA(i,j)) + CX(IB(i,j));
   }
   PrintMaxDiff(IE,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      IE(i,j) = IA(i,j) - IB(i,j);
      CE(i,j) = CX(IA(i,j)) - CX(IB(i,j));
   }
   PrintMaxDiff(IE,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      RE(i,j) = IA(i,j) * IB(i,j);
      CE(i,j) = CX(IA(i,j)) * CX(IB(i,j));
   }
   PrintMaxDiff(RE,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0.0)
      {
         RE(i,j) = IA(i,j) / IB(i,j);
         CE(i,j) = CX(IA(i,j)) / CX(IB(i,j));
      }
      else { RE(i,j) = 0; CE(i,j) = 0; }
   }
   PrintMaxDiff(RE,CE);

   cout << "check imag op _I_, _I_ op imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      IC(i,j) = IA(i,j) + _I_;
      ID(i,j) = _I_ + IA(i,j);
      CE(i,j) = CX(IA(i,j)) + CX(0,1);
   }
   PrintMaxDiff(IC,CE);  PrintMaxDiff(ID,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      IC(i,j) = IA(i,j) - _I_;
      ID(i,j) = _I_ - IA(i,j);
      CE(i,j) = CX(IA(i,j)) - CX(0,1);
      CF(i,j) = CX(0,1) - CX(IA(i,j));
   }
   PrintMaxDiff(IC,CE);  PrintMaxDiff(ID,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = IA(i,j) * _I_;
      CD(i,j) = _I_ * IA(i,j);
      CE(i,j) = CX(IA(i,j)) * CX(0,1);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = IA(i,j) / _I_;
      CE(i,j) = CX(IA(i,j)) / CX(0,1);
      if (IA(i,j) != 0.0)
      {
         CF(i,j) = CX(0,1) / CX(IA(i,j));
         CD(i,j) = _I_ / IA(i,j);
      }
      else { CD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check real op _I_, _I_ op real" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) + _I_;
      CD(i,j) = _I_ + RA(i,j);
      CE(i,j) = CX(RA(i,j)) + CX(0,1);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) - _I_;
      CD(i,j) = _I_ - RA(i,j);
      CE(i,j) = CX(RA(i,j)) - CX(0,1);
      CF(i,j) = CX(0,1) - CX(RA(i,j));
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) * _I_;
      CD(i,j) = _I_ * RA(i,j);
      CE(i,j) = CX(RA(i,j)) * CX(0,1);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) / _I_;
      CE(i,j) = CX(RA(i,j)) / CX(0,1);
      if (RA(i,j) != 0.0)
      {
         CF(i,j) = CX(0,1) / CX(RA(i,j));
         CD(i,j) = _I_ / RA(i,j);
      }
      else { CD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check polar op polar" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + CB(i,j); PC(i,j) = PA(i,j) + PB(i,j);
      PC(i,j).AssertIsValid();
   }
   PrintMaxDiff(CC,PC);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - CB(i,j); PC(i,j) = PA(i,j) - PB(i,j);
      PC(i,j).AssertIsValid();
   }
   PrintMaxDiff(CC,PC);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      //cout << i << " " << j << endl;
      CC(i,j) = CA(i,j) * CB(i,j); PC(i,j) = PA(i,j) * PB(i,j);
      PC(i,j).AssertIsValid();
   }
   PrintMaxDiff(CC,PC);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (j != 0)
      {
         CC(i,j) = CA(i,j) / CB(i,j); PC(i,j) = PA(i,j) / PB(i,j);
         PC(i,j).AssertIsValid();
      }
      else { CC(i,j) = 0.0; PC(i,j) = 0.0; }
   }
   PrintMaxDiff(CC,PC);

   cout << "check complex op Polar, Polar op complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) + PB(i,j);
      CD(i,j) = PB(i,j) + CA(i,j);
      CE(i,j) = CA(i,j) + CB(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = CA(i,j) - PB(i,j);
      CD(i,j) = PB(i,j) - CA(i,j);
      CE(i,j) = CA(i,j) - CB(i,j);
      CF(i,j) = CB(i,j) - CA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   cout << "check imag op Polar, Polar op imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = IA(i,j) + PB(i,j);
      CD(i,j) = PB(i,j) + IA(i,j);
      CE(i,j) = IA(i,j) + CB(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = IA(i,j) - PB(i,j);
      CD(i,j) = PB(i,j) - IA(i,j);
      CE(i,j) = IA(i,j) - CB(i,j);
      CF(i,j) = CB(i,j) - IA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      PC(i,j) = PA(i,j) * IB(i,j);  PC(i,j).AssertIsValid();
      PD(i,j) = IB(i,j) * PA(i,j);  PD(i,j).AssertIsValid();
      CE(i,j) = CA(i,j) * CX(IB(i,j));
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0.0)
      {
         PC(i,j) = PA(i,j) / IB(i,j);  PC(i,j).AssertIsValid();
         CE(i,j) = CA(i,j) / CX(IB(i,j));
      }
      else { CC(i,j) = 0; CE(i,j) = 0; }
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(IB(i,j)) / CA(i,j);
         PD(i,j) = IB(i,j) / PA(i,j);  PD(i,j).AssertIsValid();
      }
      else { PD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CF);

   cout << "check real op Polar, Polar op real" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) + PB(i,j);
      CD(i,j) = PB(i,j) + RA(i,j);
      CE(i,j) = RA(i,j) + CB(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = RA(i,j) - PB(i,j);
      CD(i,j) = PB(i,j) - RA(i,j);
      CE(i,j) = RA(i,j) - CB(i,j);
      CF(i,j) = CB(i,j) - RA(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      PC(i,j) = PA(i,j) * RB(i,j);  PC(i,j).AssertIsValid();
      PD(i,j) = RB(i,j) * PA(i,j);  PD(i,j).AssertIsValid();
      CE(i,j) = CA(i,j) * CX(RB(i,j));
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RB(i,j) != 0.0)
      {
         PC(i,j) = PA(i,j) / RB(i,j);  PC(i,j).AssertIsValid();
         CE(i,j) = CA(i,j) / CX(RB(i,j));
      }
      else { CC(i,j) = 0; CE(i,j) = 0; }
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(RB(i,j)) / CA(i,j);
         PD(i,j) = RB(i,j) / PA(i,j);  PD(i,j).AssertIsValid();
      }
      else { PD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CF);

   cout << "check imag op Polar, Polar op imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = _I_ + PB(i,j);
      CD(i,j) = PB(i,j) + _I_;
      CE(i,j) = _I_ + CB(i,j);
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CC(i,j) = _I_ - PB(i,j);
      CD(i,j) = PB(i,j) - _I_;
      CE(i,j) = _I_ - CB(i,j);
      CF(i,j) = CB(i,j) - _I_;
   }
   PrintMaxDiff(CC,CE);  PrintMaxDiff(CD,CF);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      PC(i,j) = PA(i,j) * _I_;  PC(i,j).AssertIsValid();
      PD(i,j) = _I_ * PA(i,j);  PD(i,j).AssertIsValid();
      CE(i,j) = CA(i,j) * CX(_I_);
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CE);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      PC(i,j) = PA(i,j) / _I_; PC(i,j).AssertIsValid();
      CE(i,j) = CA(i,j) / CX(_I_);
      if (CA(i,j) != 0.0)
      {
         CF(i,j) = CX(_I_) / CA(i,j);
         PD(i,j) = _I_ / PA(i,j); PD(i,j).AssertIsValid();
      }
      else { PD(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxDiff(PC,CE);  PrintMaxDiff(PD,CF);

   cout << "check complex op= complex" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + CB(i,j);
   CD = CA; CD += CB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - CB(i,j);
   CD = CA; CD -= CB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * CB(i,j);
   CD = CA; CD *= CB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (CB(i,j) != 0)
         { CC(i,j) = CA(i,j) / CB(i,j); CD(i,j) = CA(i,j); CD(i,j) /= CB(i,j); }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxDiff(CC, CD);

   cout << "check complex op= real" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + RB(i,j);
   CD = CA; CD += RB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - RB(i,j);
   CD = CA; CD -= RB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * RB(i,j);
   CD = CA; CD *= RB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RB(i,j) != 0)
         { CC(i,j) = CA(i,j) / RB(i,j); CD(i,j) = CA(i,j); CD(i,j) /= RB(i,j); }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxDiff(CC, CD);

   cout << "check complex op= imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + IB(i,j);
   CD = CA; CD += IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - IB(i,j);
   CD = CA; CD -= IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * IB(i,j);
   CD = CA; CD *= IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0)
         { CC(i,j) = CA(i,j) / IB(i,j); CD(i,j) = CA(i,j); CD(i,j) /= IB(i,j); }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxDiff(CC, CD);

   cout << "check complex op= imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + IB(i,j);
   CD = CA; CD += IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - IB(i,j);
   CD = CA; CD -= IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * IB(i,j);
   CD = CA; CD *= IB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0)
         { CC(i,j) = CA(i,j) / IB(i,j); CD(i,j) = CA(i,j); CD(i,j) /= IB(i,j); }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxDiff(CC, CD);

   cout << "check complex op= _I_" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + _I_;
   CD = CA; CD += _I_; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - _I_;
   CD = CA; CD -= _I_; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * _I_;
   CD = CA; CD *= _I_; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) / _I_;
   CD = CA; CD /= _I_; PrintMaxDiff(CC, CD);

   cout << "check complex op= polar" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) + CB(i,j);
   CD = CA; CD += PB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) - CB(i,j);
   CD = CA; CD -= PB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) CC(i,j) = CA(i,j) * CB(i,j);
   CD = CA; CD *= PB; PrintMaxDiff(CC, CD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (CB(i,j) != 0)
         { CC(i,j) = CA(i,j) / CB(i,j); CD(i,j) = CA(i,j); CD(i,j) /= PB(i,j); }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxDiff(CC, CD);

   cout << "check imag op= imag" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) IC(i,j) = IA(i,j) + IB(i,j);
   ID = IA; ID += IB; PrintMaxDiff(IC, ID);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) IC(i,j) = IA(i,j) - IB(i,j);
   ID = IA; ID -= IB; PrintMaxDiff(IC, ID);

   cout << "check imag op= real" << endl;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++) IC(i,j) = IA(i,j) * RB(i,j);
   ID = IA; ID *= RB; PrintMaxDiff(IC, ID);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RB(i,j) != 0)
         { IC(i,j) = IA(i,j) / RB(i,j); ID(i,j) = IA(i,j); ID(i,j) /= RB(i,j); }
      else { IC(i,j) = Imag(0); ID(i,j) = Imag(0); }
   }
   PrintMaxDiff(IC, ID);

   cout << "check polar op= polar" << endl;

   CD = CA; CD += CB; PD = PA; PD += PB; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   CD = CA; CD -= CB; PD = PA; PD -= PB; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   CD = CA; CD *= CB; PD = PA; PD *= PB; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (CB(i,j) != 0)
         { CD(i,j) = CA(i,j) / CB(i,j); PD(i,j) = PA(i,j); PD(i,j) /= PB(i,j); }
      else { CD(i,j) = 0; PD(i,j) = 0; }
   }
   PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   cout << "check polar op= complex" << endl;

   CD = CA; CD += CB; PD = PA; PD += CB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD -= CB; PD = PA; PD -= CB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD *= CB; PD = PA; PD *= CB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (CB(i,j) != 0)
         { CD(i,j) = CA(i,j) / CB(i,j); PD(i,j) = PA(i,j); PD(i,j) /= CB(i,j); }
      else { CD(i,j) = 0; PD(i,j) = 0; }
   }
   PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   cout << "check polar op= real" << endl;

   CD = CA; CD += RB; PD = PA; PD += RB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD -= RB; PD = PA; PD -= RB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD *= RB; PD = PA; PD *= RB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RB(i,j) != 0)
         { CD(i,j) = CA(i,j) / RB(i,j); PD(i,j) = PA(i,j); PD(i,j) /= RB(i,j); }
      else { CD(i,j) = 0; PD(i,j) = 0; }
   }
   PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   cout << "check polar op= imag" << endl;

   CD = CA; CD += IB; PD = PA; PD += IB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD -= IB; PD = PA; PD -= IB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   CD = CA; CD *= IB; PD = PA; PD *= IB; PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IB(i,j) != 0)
         { CD(i,j) = CA(i,j) / IB(i,j); PD(i,j) = PA(i,j); PD(i,j) /= IB(i,j); }
      else { CD(i,j) = 0; PD(i,j) = 0; }
   }
   PrintMaxDiff(CD, PD);  AssertIsValid(PD);

   cout << "check polar op= imag" << endl;

   CD = CA; CD += _I_; PD = PA; PD += _I_; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   CD = CA; CD -= _I_; PD = PA; PD -= _I_; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   CD = CA; CD *= _I_; PD = PA; PD *= _I_; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   CD = CA; CD /= _I_; PD = PA; PD /= _I_; PrintMaxDiff(CD, PD); AssertIsValid(PD);

   cout << "check complex ==, != complex" << endl;

   bool OnDiag = true; bool OffDiag = false;

   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (i == j)
      {
         if ( CA(i,j) == CB(i,j) ) {} else OnDiag = false;
         if ( CA(i,j) != CB(i,j) ) OnDiag = false;
      }
      else
      {
         if ( CA(i,j) != CB(i,j) ) {} else OffDiag = true;
         if ( CA(i,j) == CB(i,j) ) OffDiag = true;
      }
   }

   if (OnDiag && !OffDiag) cout << "test passes" << endl;
   else { cout << "test fails" << endl; OverallMax = 100; }

   cout << "check polar ==, != polar" << endl;
   TestCompare(PA, PB);

   cout << "check complex ==, != imag" << endl;
   TestCompare(CA, IB);

   cout << "check imag ==, != complex" << endl;
   TestCompare(IA, CB);

   cout << "check complex ==, != real" << endl;
   TestCompare(CA, RB);

   cout << "check real ==, != complex" << endl;
   TestCompare(RA, CB);

   cout << "check imag ==, != real" << endl;
   TestCompare(IA, RB);

   cout << "check real ==, != imag" << endl;
   TestCompare(RA, IB);

   cout << "check polar ==, != imag" << endl;
   TestCompare(PA, IB);

   cout << "check imag ==, != polar" << endl;
   TestCompare(IA, PB);

   cout << "check polar ==, != real" << endl;
   TestCompare(PA, RB);

   cout << "check real ==, != polar" << endl;
   TestCompare(RA, PB);

   cout << "check complex ==, != _I_ (both directions)" << endl;
   TestCompareWithI(CA);

   cout << "check polar ==, != _I_ (both directions)" << endl;
   TestCompareWithI(PA);

   cout << "check real ==, != _I_ (both directions)" << endl;
   TestCompareWithI(RA);

   cout << "check imag ==, != _I_ (both directions)" << endl;
   TestCompareWithI(IA);



   cout << "check pow(CX, CX), pow(Polar, CX)" << endl;
   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      CG(i,j) = exp(CA(i,j));
      CC(i,j) = pow(CG(i,j), CB(i,j));
      CF(i,j) = log(CG(i,j));  // shrink argument part
      CD(i,j) = exp(CF(i,j) * CB(i,j));
      PC(i,j) = pow(polar_exp(CA(i,j)), CB(i,j));
      CH(i,j) = exp(CF(i,j));
   }
   PrintMaxRelDiff(CC, CD);  PrintMaxRelDiff(PC, CC); AssertIsValid(PC);
   PrintMaxRelDiff(CG, CH);   // check shrunken bit

   cout << "check pow(Real, CX), pow(Imag, CX)" << endl;
   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RA(i,j) != 0 || real(CB(i, j)) > 0)
      {
         CC(i,j) = pow(RA(i,j), CB(i,j));
         CD(i,j) = pow(CX(RA(i,j)), CB(i,j));
      }
      else { CC(i,j) = 0; CD(i,j) = 0; }
      if (IA(i,j) != 0 || real(CB(i, j)) > 0)
      {
         CE(i,j) = pow(IA(i,j), CB(i,j));
         CF(i,j) = pow(CX(IA(i,j)), CB(i,j));
      }
      else { CE(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxRelDiff(CC, CD);  PrintMaxRelDiff(CE, CF);

   cout <<
      "check pow(CX, Real), pow(Polar, Real), pow(CX, Imag), pow(Polar, Imag)"
      << endl;
   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (CA(i,j) != 0 || RB(i,j) > 0)
      {
         CC(i,j) = pow(CA(i,j), RB(i,j));
         PC(i,j) = pow(PA(i,j), RB(i,j));
         CD(i,j) = pow(CA(i,j), CX(RB(i,j)));
      }
      else { CC(i,j) = 0; CD(i,j) = 0; PC(i,j) = 0; }
      if (CA(i,j) != 0)
      {
         CE(i,j) = pow(CA(i,j), IB(i,j));
         PD(i,j) = pow(PA(i,j), IB(i,j));
         CF(i,j) = pow(CA(i,j), CX(IB(i,j)));
      }
      else { CE(i,j) = 0; CF(i,j) = 0; PD(i,j) = 0; }
   }
   PrintMaxRelDiff(CC, CD);  PrintMaxRelDiff(CE, CF);
   PrintMaxRelDiff(PC, CC);  PrintMaxRelDiff(PD, CE);

   cout << "check pow(Imag, Complex)" << endl;
   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (IA(i,j) != 0 || real(CB(i,j)) > 0)
      {
         CC(i,j) = pow(IA(i,j), CB(i,j));
         CD(i,j) = pow(CX(IA(i,j)), CB(i,j));
      }
      else { CC(i,j) = 0; CD(i,j) = 0; }
   }
   PrintMaxRelDiff(CC, CD);

   cout << "check pow(Real, Imag), pow(Imag, Imag)" << endl;
   for (i = 0; i < n; i++) for (j = 0; j < n; j++)
   {
      if (RA(i,j) != 0)
      {
         CC(i,j) = pow(RA(i,j), IB(i,j));
         CD(i,j) = pow(CX(RA(i,j)), CX(IB(i,j)));
      }
      else { CC(i,j) = 0; CD(i,j) = 0; }
      if (IA(i,j) != 0)
      {
         CE(i,j) = pow(IA(i,j), IB(i,j));
         CF(i,j) = pow(CX(IA(i,j)), CX(IB(i,j)));
      }
      else { CE(i,j) = 0; CF(i,j) = 0; }
   }
   PrintMaxRelDiff(CC, CD);  PrintMaxRelDiff(CE, CF);

   cout << "end binary tests" << endl;
   return OverallMax;
}
