BORLANDPATH = "C:\program files\Borland\cbuilder6"

TASM = TASM32
TLIB = tlib
TLINK = ilink32
LIBPATH = $(BORLANDPATH)\LIB
INCLUDEPATH = $(BORLANDPATH)\INCLUDE

DIFF = sdiff
PRE =

CC = bcc32 -W- -v- -H- -6 -Og -Oi -Ov -I$(INCLUDEPATH)

.cpp.obj:
   $(CC) -c {$< }

everything:    	genmake.exe sdiff.exe 

str_lobj = str.obj myexcept.obj format.obj liststr.obj gstring.obj str_fns.obj commline.obj

str.lib:       	$(str_lobj)
   $(TLIB) $@ /P32 /u $(str_lobj)

genmake_obj = genmake.obj

genmake.exe:   	$(genmake_obj) str.lib
   $(TLINK) /x/L$(LIBPATH)/Gn -Tpe -ap -c @&&|
c0x32.obj $(genmake_obj),$@,, str.lib import32.lib cw32.lib
|

sdiff_obj = sdiff.obj

sdiff.exe:     	$(sdiff_obj) str.lib
   $(TLINK) /x/L$(LIBPATH)/Gn -Tpe -ap -c @&&|
c0x32.obj $(sdiff_obj),$@,, str.lib import32.lib cw32.lib
|

str.obj:       	str.cpp include.h str.h myexcept.h

myexcept.obj:  	myexcept.cpp include.h myexcept.h

format.obj:    	format.cpp include.h str.h format.h myexcept.h

liststr.obj:   	liststr.cpp include.h str.h gstring.h str_fns.h myexcept.h

gstring.obj:   	gstring.cpp include.h str.h gstring.h myexcept.h str_fns.h

str_fns.obj:   	str_fns.cpp str.h str_fns.h include.h myexcept.h

commline.obj:  	commline.cpp include.h myexcept.h str.h commline.h str_fns.h

genmake.obj:   	genmake.cpp include.h str.h gstring.h commline.h myexcept.h str_fns.h

sdiff.obj:     	sdiff.cpp include.h str.h gstring.h commline.h myexcept.h str_fns.h

genmake.txx:   	genmake.exe
		$(PRE)genmake > genmake.txx
		$(DIFF) genmake.txt genmake.txx

sdiff.txx:     	sdiff.exe
		$(PRE)sdiff > sdiff.txx
		$(DIFF) sdiff.txt sdiff.txx

