// sillydif.cpp
// Line by line compare two files

#define WANT_STREAM
#define WANT_MATH
#define WANT_FSTREAM

#include "include.h"
#include "str.h"
#include "gstring.h"
#include "commline.h"



typedef StringList::iterator SLI;
typedef StringList::const_iterator SLCI;

void Line()
{
   cout << "---------------------------------------------------------" << endl;
}

int main(int argc, char** argv)
{
   CommandLine CL(argc, argv);
   int N = CL.NumberOfArgs();

   if (N != 2) { cout << "Need two file names" << endl; exit(1); }


   StringList Left;
   StringList Right;

   String lfn = CL.GetArg(1);
   ifstream lis(lfn.c_str());
   if (!lis) { cout << "Can't find file " << lfn << endl; }
   lis >> Left;
   String rfn = CL.GetArg(2);
   ifstream ris(rfn.c_str());
   if (!ris) { cout << "Can't find file " << rfn << endl; }
   ris >> Right;

   Line();
   cout << "Line by line comparison of " << lfn << " and " << rfn << endl;
   int n = 0; int i = 0;
   SLI li = Left.begin(); SLI ri = Right.begin();

   while(++i)
   {
      if (*li != *ri)
      {
         if (n >= 100)
         {
            cout << "*** more than 100 differences ***" << endl;
            Line(); return 0;
         }
         cout << "*** mismatch at line " << i << " ***" << endl;
         cout << "< " << *li << endl;
         cout << "> " << *ri << endl;
         ++n;
      }
      ++li; ++ ri;
      if (li == Left.end() && ri == Right.end())
      {
         if (n == 0) cout << "*** files agree ***" << endl;
         else if (n == 1) cout << "*** one line differs ***" << endl;
         else cout << "*** " << n << " lines differ ***" << endl;
         Line(); return 0;
      }
      if (li == Left.end() || ri == Right.end())
      {
         cout << "*** file length mismatch ***" << endl;
         Line(); return 0;
      }
   }
   return 0;
}


