// Eigen value decomposition using both NRC++ and Newmat routines.

#define WANT_MATH
#define WANT_STREAM
#define WANT_TIME

#include "newmatap.h"

#include "nr.h"

using namespace NR;

#ifdef use_namespace
using namespace NEWMAT;
#endif

int my_main()
{
   int n = 300;                       // dimensions of test matrix
   IdentityMatrix I(n);
   int i, j;
   SymmetricMatrix A(n);

   // enter random numbers into the elements of A
   int idum = -1;      // seed for ran1
   for (i = 1; i <= n; ++i) for (j = 1; j <= i; ++j) A(i, j) = ran1(idum);
   Matrix U1 = A;               // convert to full Matrix
   ColumnVector D1(n), E1(n);   // must set dimensions for NRC++
   cout << "Begin numerical recipes in C++ eigenvalue decomposition" << endl;
   Real Begin1 = ((double)clock())/(double)CLOCKS_PER_SEC;
   tred2(U1, D1, E1);                // the NRC++ routines
   tqli(D1, E1, U1);
   Real End1 = ((double)clock())/(double)CLOCKS_PER_SEC;
   cout << "End decomposition: time  = " << End1 - Begin1 << endl;
   cout << "Maximum error in product = " 
      << (U1 * D1.AsDiagonal() * U1.t() - A).MaximumAbsoluteValue() << endl;
   cout << "Orthogonality check      = " 
      << (U1 * U1.t() - I).MaximumAbsoluteValue() << endl;
   DiagonalMatrix D1S = D1.AsDiagonal(); SortAscending(D1S);
   
   DiagonalMatrix D2;
   Matrix U2;
   cout << "Begin newmat eigenvalue decomposition" << endl;
   Real Begin2 = ((double)clock())/(double)CLOCKS_PER_SEC;
   EigenValues(A, D2, U2);          // the Newmat routine
   Real End2 = ((double)clock())/(double)CLOCKS_PER_SEC;
   cout << "End decomposition: time  = " << End2 - Begin2 << endl;
   cout << "Maximum error in product = " 
      << (U2 * D2 * U2.t() - A).MaximumAbsoluteValue() << endl;
   cout << "Orthogonality check      = " 
      << (U2 * U2.t() - I).MaximumAbsoluteValue() << endl;
   cout << "Maximum difference in eigenvalues = " <<
      (D1S - D2).MaximumAbsoluteValue() << endl;
    
   return 0;

}

// catch exceptions generated by newmat
// use newmat names for exception functions so we can use simulated
// exceptions if necessary.

int main()
{
   Try { return my_main(); }
   Catch(BaseException)
      { cout << "\nException generated\n\n" << BaseException::what() << "\n"; }
   CatchAll { cout << "\nUnrecognised exception\n"; }

   return 0;

}


